####################################################
### code chunk number : A Real Data Example
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## Poverty_Level: OK
rt = read.table("data/Poverty_Level.txt", head=TRUE); rt
class(rt)
dim(rt)
x = rt[, 1]/100; x
class(x)
length(x)


data_outline(x)
range(x)
L_x = length(x); L_x
n = L_x - 1; n

## 
## Histogram
## 
dev.new()
col = c("blue")
lty = 1
hist(x, probability = TRUE, breaks = 20,
    main = paste("Histogram of" , "x"), 
    xlab = "x")
lines(density(x), lty = lty[1], col = col[1], lwd = 4)
leg.txt = c("Density estimation curve")
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = "figure/N-NIG_Histogram_x", type = c("pdf"))
savePlot(filename = "figure/N-NIG_Histogram_x", type = c("jpg"))


## 
## Goodness-of-fit: KS test
## 

## 
## Moment estimators
## 
mu0_1_v0_1_u0_1 = Moment_estimators(x[1:n])
mu0_1 = mu0_1_v0_1_u0_1[1]; mu0_1
v0_1 = mu0_1_v0_1_u0_1[2]; v0_1
u0_1 = mu0_1_v0_1_u0_1[3]; u0_1

## ks_test
ks_test_1_pt      = ks.test((x[1:n] - mu0_1) / sqrt(u0_1), "pt", v0_1); ks_test_1_pt
ks_test_1_p_N_NIG = ks.test(x[1:n], "p_N_NIG_mu0_v0_u0", mu0_1, v0_1, u0_1); ks_test_1_p_N_NIG

## Compute_Estimators_PESLs_new
source("subfunctions.R")
res_moment = Compute_Estimators_PESLs_new(mu0 = mu0_1, k0 = 1, v0 = v0_1, sigma0 = sqrt(u0_1 / 2), x_np1 = x[n + 1]); res_moment

## Compute the mean and variance of the data
E_V_moment = Compute_mean_variance(mu0 = mu0_1, v0 = v0_1, u0 = u0_1); E_V_moment


##
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
##
source("subfunctions.R")
mu0_2_v0_2_u0_2 = Newtons(fun = moment_fun, p = mu0_1_v0_1_u0_1, x = x[1:n])$root
mu0_2 = mu0_2_v0_2_u0_2[1]; mu0_2
v0_2 = mu0_2_v0_2_u0_2[2]; v0_2
u0_2 = mu0_2_v0_2_u0_2[3]; u0_2

## ks_test
ks_test_2_pt      = ks.test((x[1:n] - mu0_2) / sqrt(u0_2), "pt", v0_2); ks_test_2_pt
ks_test_2_p_N_NIG = ks.test(x[1:n], "p_N_NIG_mu0_v0_u0", mu0_2, v0_2, u0_2); ks_test_2_p_N_NIG

## Compute_Estimators_PESLs_new
res_MLE = Compute_Estimators_PESLs_new(mu0 = mu0_2, k0 = 1, v0 = v0_2, sigma0 = sqrt(u0_2 / 2), x_np1 = x[n + 1]); res_MLE

## Compute the mean and variance of the data
E_V_MLE = Compute_mean_variance(mu0 = mu0_2, v0 = v0_2, u0 = u0_2); E_V_MLE

